/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    private static Reference<Map<String, String>> bundledRegistry;
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private Map<String, RegistryKeyDescriptor> myContributedKeys = Collections.emptyMap();
    private static final Registry ourInstance;
    private volatile boolean isLoaded;
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        RegistryValue registryValue = this.myValues.computeIfAbsent(key, s2 -> new RegistryValue(this, (String)s2, this.myContributedKeys.get(s2)));
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.getInstance().doGet(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.COMPONENTS_REGISTERED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    @Nullable
    private static Map<String, String> loadFromBundledConfig() throws IOException {
        Map<String, String> result2;
        Reference<Map<String, String>> bundleRef = bundledRegistry;
        Map<String, String> map = result2 = bundleRef == null ? null : bundleRef.get();
        if (result2 != null) {
            return result2;
        }
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>(1800);
        boolean mainFound = Registry.loadFromResource("misc/registry.properties", map2);
        boolean overrideFound = Registry.loadFromResource("misc/registry.override.properties", map2);
        if (!mainFound && !overrideFound) {
            return null;
        }
        bundledRegistry = new SoftReference<LinkedHashMap<String, String>>(map2);
        return map2;
    }

    private static boolean loadFromResource(String sourceResourceName, final Map<String, String> targetMap) throws IOException {
        InputStream stream = Registry.class.getClassLoader().getResourceAsStream(sourceResourceName);
        if (stream == null) {
            return false;
        }
        try {
            new Properties(){

                @Override
                public Object put(Object key, Object value2) {
                    return targetMap.put((String)key, (String)value2);
                }
            }.load(stream);
        }
        finally {
            stream.close();
        }
        return true;
    }

    @Nullable
    public String getBundleValueOrNull(@NonNls @NotNull String key) {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            return contributed.getDefaultValue();
        }
        try {
            Map<String, String> bundle = Registry.loadFromBundledConfig();
            return bundle == null ? null : bundle.get(key);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @NotNull
    String getBundleValue(@NonNls @NotNull String key) throws MissingResourceException {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(14);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            String string = contributed.getDefaultValue();
            if (string == null) {
                Registry.$$$reportNull$$$0(15);
            }
            return string;
        }
        String result2 = this.getBundleValueOrNull(key);
        if (result2 == null) {
            throw new MissingResourceException("Registry key " + key + " is not defined", "misc.registry", key);
        }
        String string = result2;
        if (string == null) {
            Registry.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_LOADED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return registry;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map = this.myUserProperties;
        if (map == null) {
            Registry.$$$reportNull$$$0(25);
        }
        return map;
    }

    @NotNull
    RegistryValueListener getValueChangeListener() {
        RegistryValueListener registryValueListener = this.valueChangeListener;
        if (registryValueListener == null) {
            Registry.$$$reportNull$$$0(30);
        }
        return registryValueListener;
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromState";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "updateStateInternal";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueChangeListener";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStateInternal";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_getWithoutStateCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValueOrNull";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fromState";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateStateInternal";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setKeys";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mutateContributedKeys";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadStateInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

