/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.AnnotationTextCollector;
import com.intellij.psi.impl.compiled.FirstPassData;
import com.intellij.util.ArrayUtil;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;

class ClsTypeAnnotationCollector
extends TypeAnnotationContainer.Collector {
    @NotNull
    private final FirstPassData myFirstPassData;

    ClsTypeAnnotationCollector(@NotNull TypeInfo info, @NotNull FirstPassData classInfo) {
        if (info == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(0);
        }
        if (classInfo == null) {
            ClsTypeAnnotationCollector.$$$reportNull$$$0(1);
        }
        super(info);
        this.myFirstPassData = classInfo;
    }

    void add(TypePath path, String text) {
        byte[] translated = this.translatePath(path);
        if (translated != null) {
            this.add(translated, text);
        }
    }

    AnnotationVisitor collect(@Nullable TypePath path, @Nullable String desc) {
        return new AnnotationTextCollector(desc, this.myFirstPassData, text -> this.add(path, (String)text));
    }

    private byte[] translatePath(@Nullable TypePath path) {
        TypeInfo curType = this.myTypeInfo;
        int depth = curType.innerDepth();
        if (path == null) {
            if (depth == 0) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] result2 = new byte[depth];
            Arrays.fill(result2, (byte)1);
            return result2;
        }
        ByteArrayOutputStream result3 = new ByteArrayOutputStream();
        int length = path.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            byte step = (byte)path.getStep(i2);
            if (step == 1) {
                if (depth == 0) {
                    return null;
                }
                --depth;
                continue;
            }
            while (depth-- > 0) {
                result3.write(1);
                if (!(curType instanceof TypeInfo.RefTypeInfo)) {
                    return null;
                }
                curType = ((TypeInfo.RefTypeInfo)curType).outerType();
            }
            switch (step) {
                case 0: {
                    if (!(curType instanceof TypeInfo.DerivedTypeInfo) || curType.getKind() != TypeInfo.TypeKind.ARRAY && curType.getKind() != TypeInfo.TypeKind.ELLIPSIS) {
                        return null;
                    }
                    curType = ((TypeInfo.DerivedTypeInfo)curType).child();
                    result3.write(0);
                    break;
                }
                case 2: {
                    if (!(curType instanceof TypeInfo.DerivedTypeInfo) || curType.getKind() != TypeInfo.TypeKind.EXTENDS && curType.getKind() != TypeInfo.TypeKind.SUPER) {
                        return null;
                    }
                    curType = ((TypeInfo.DerivedTypeInfo)curType).child();
                    result3.write(2);
                    break;
                }
                case 3: {
                    int argumentIndex = path.getStepArgument(i2);
                    if (!(curType instanceof TypeInfo.RefTypeInfo)) {
                        return null;
                    }
                    curType = ((TypeInfo.RefTypeInfo)curType).genericComponent(argumentIndex);
                    result3.write(3);
                    result3.write(argumentIndex);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (curType == null) {
                return null;
            }
            depth = curType.innerDepth();
        }
        while (depth-- > 0) {
            result3.write(1);
        }
        return result3.toByteArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "classInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/compiled/ClsTypeAnnotationCollector";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

