/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.profiling;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerHelper;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerReflected;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "profilerPath", "", "command", "outputDir", "Ljava/io/File;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "getCommand", "()Ljava/lang/String;", "getOutputDir", "()Ljava/io/File;", "profiler", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "runDate", "Ljava/util/Date;", "formatter", "Ljava/text/SimpleDateFormat;", "active", "", "startProfiling", "", "stopProfiling", "restartProfiling", "dumpProfile", "postfix", "notifyCompilationFinished", "Companion", "cli"})
public final class ProfilingCompilerPerformanceManager
extends PerformanceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String command;
    @NotNull
    private final File outputDir;
    @NotNull
    private final AsyncProfilerReflected profiler;
    @NotNull
    private final Date runDate;
    @NotNull
    private final SimpleDateFormat formatter;
    private boolean active;

    public ProfilingCompilerPerformanceManager(@NotNull String profilerPath, @NotNull String command, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter(profilerPath, "profilerPath");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        super(JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), "Profiling");
        this.command = command;
        this.outputDir = outputDir;
        this.profiler = AsyncProfilerHelper.INSTANCE.getInstance(profilerPath);
        this.runDate = new Date();
        this.formatter = new SimpleDateFormat("yyyy-MM-dd__HH-mm");
        this.startProfiling();
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    private final void startProfiling() {
        this.profiler.execute(this.command);
        this.active = true;
    }

    private final void stopProfiling() {
        if (this.active) {
            this.profiler.stop();
        }
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpProfile(String postfix) {
        this.outputDir.mkdirs();
        File outputFile = FilesKt.resolve(this.outputDir, "snapshot-" + this.formatter.format(this.runDate) + '-' + postfix + ".collapsed");
        String profile = this.profiler.execute("collapsed");
        Closeable closeable = new FileOutputStream(outputFile);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            Iterator<String> iterator2 = StringsKt.chunkedSequence(profile, 0x100000).iterator();
            while (iterator2.hasNext()) {
                String chunk = iterator2.next();
                byte[] byArray = chunk.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                out.write(byArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        this.active = false;
    }

    @Override
    public void notifyCompilationFinished() {
        this.dumpProfile("final");
        this.stopProfiling();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "profileCompilerArgument", "", "detailedPerf", "", "cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProfilingCompilerPerformanceManager create(@NotNull String profileCompilerArgument, boolean detailedPerf) {
            ProfilingCompilerPerformanceManager profilingCompilerPerformanceManager;
            Intrinsics.checkNotNullParameter(profileCompilerArgument, "profileCompilerArgument");
            String[] stringArray = new String[]{":"};
            List list = StringsKt.split$default((CharSequence)profileCompilerArgument, stringArray, false, 3, 2, null);
            String path = (String)list.get(0);
            String command = (String)list.get(1);
            String outputDir = (String)list.get(2);
            ProfilingCompilerPerformanceManager $this$create_u24lambda_u240 = profilingCompilerPerformanceManager = new ProfilingCompilerPerformanceManager(path, command, new File(outputDir));
            boolean bl = false;
            $this$create_u24lambda_u240.setDetailedPerf(detailedPerf);
            return profilingCompilerPerformanceManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

