/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "", "buildDiffs", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "<init>", "(Ljava/util/List;)V", "getBuildDiffs", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "incremental-compilation-impl"})
public final class BuildDiffsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BuildDifference> buildDiffs;
    public static final int MAX_DIFFS_ENTRIES = 10;
    private static int CURRENT_VERSION;

    public BuildDiffsStorage(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkNotNullParameter(buildDiffs, "buildDiffs");
        this.buildDiffs = buildDiffs;
    }

    @NotNull
    public final List<BuildDifference> getBuildDiffs() {
        return this.buildDiffs;
    }

    @NotNull
    public final List<BuildDifference> component1() {
        return this.buildDiffs;
    }

    @NotNull
    public final BuildDiffsStorage copy(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkNotNullParameter(buildDiffs, "buildDiffs");
        return new BuildDiffsStorage(buildDiffs);
    }

    public static /* synthetic */ BuildDiffsStorage copy$default(BuildDiffsStorage buildDiffsStorage, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = buildDiffsStorage.buildDiffs;
        }
        return buildDiffsStorage.copy(list);
    }

    @NotNull
    public String toString() {
        return "BuildDiffsStorage(buildDiffs=" + this.buildDiffs + ')';
    }

    public int hashCode() {
        return ((Object)this.buildDiffs).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildDiffsStorage)) {
            return false;
        }
        BuildDiffsStorage buildDiffsStorage = (BuildDiffsStorage)other;
        return Intrinsics.areEqual(this.buildDiffs, buildDiffsStorage.buildDiffs);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ \u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005J\f\u0010\u0012\u001a\u00020\f*\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0013H\u0002J\u001a\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001c*\u00020\u0013J\u001a\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001aj\b\u0012\u0004\u0012\u00020\u001e`\u001c*\u00020\u0013J\u0014\u0010\u001f\u001a\u00020\u000e*\u00020\u00152\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u000e*\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0#J\u0018\u0010$\u001a\u00020\u000e*\u00020\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0#R\u000e\u0010&\u001a\u00020'X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage$Companion;", "", "<init>", "()V", "readFromFile", "Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "file", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "readDiffsFromFile", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "writeToFile", "", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "storage", "readBuildDifference", "Ljava/io/ObjectInputStream;", "writeBuildDifference", "Ljava/io/ObjectOutputStream;", "diff", "readDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "readFqNames", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/ArrayList;", "readLookups", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "writeDirtyData", "dirtyData", "writeFqNames", "dirtyClassesFqNames", "", "writeLookups", "lookupSymbols", "MAX_DIFFS_ENTRIES", "", "CURRENT_VERSION", "getCURRENT_VERSION", "()I", "setCURRENT_VERSION", "(I)V", "incremental-compilation-impl"})
    @SourceDebugExtension(value={"SMAP\nBuildDiffsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDiffsStorage.kt\norg/jetbrains/kotlin/incremental/BuildDiffsStorage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1068#3:155\n*S KotlinDebug\n*F\n+ 1 BuildDiffsStorage.kt\norg/jetbrains/kotlin/incremental/BuildDiffsStorage$Companion\n*L\n75#1:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BuildDiffsStorage readFromFile(@NotNull File file, @Nullable ICReporter reporter) {
            BuildDiffsStorage buildDiffsStorage;
            List<BuildDifference> diffs;
            Intrinsics.checkNotNullParameter(file, "file");
            List<BuildDifference> list = diffs = this.readDiffsFromFile(file, reporter);
            if (list != null) {
                List<BuildDifference> it = list;
                boolean bl = false;
                buildDiffsStorage = new BuildDiffsStorage(it);
            } else {
                buildDiffsStorage = null;
            }
            return buildDiffsStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final List<BuildDifference> readDiffsFromFile(@NotNull File file, @Nullable ICReporter reporter) {
            Intrinsics.checkNotNullParameter(file, "file");
            if (!file.exists()) {
                return null;
            }
            try {
                Closeable closeable = new FileInputStream(file);
                int n2 = 8192;
                closeable = new ObjectInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n2));
                Throwable throwable = null;
                try {
                    ObjectInputStream input = (ObjectInputStream)closeable;
                    boolean bl = false;
                    int version2 = input.readInt();
                    if (version2 != Companion.getCURRENT_VERSION()) {
                        org.jetbrains.kotlin.incremental.BuildDiffsStorage$Companion.readDiffsFromFile$reportFail(reporter, file, "incompatible version " + version2 + ", actual version is " + Companion.getCURRENT_VERSION());
                        List<BuildDifference> list = null;
                        return list;
                    }
                    int size = input.readInt();
                    ArrayList<BuildDifference> result2 = new ArrayList<BuildDifference>(size);
                    int n3 = 0;
                    while (n3 < size) {
                        int it = n3++;
                        boolean bl2 = false;
                        result2.add(Companion.readBuildDifference(input));
                    }
                    List list = result2;
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e2) {
                org.jetbrains.kotlin.incremental.BuildDiffsStorage$Companion.readDiffsFromFile$reportFail(reporter, file, e2.toString());
                return null;
            }
        }

        public final void writeToFile(@NotNull IncrementalCompilationContext icContext, @NotNull File file, @NotNull BuildDiffsStorage storage) {
            Intrinsics.checkNotNullParameter(icContext, "icContext");
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(storage, "storage");
            file.getParentFile().mkdirs();
            try {
                CompilationTransaction compilationTransaction = icContext.getTransaction();
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
                CompilationTransactionKt.write(compilationTransaction, path, () -> Companion.writeToFile$lambda$0(file, storage));
            }
            catch (IOException e2) {
                ICReporterKt.info(icContext.getReporter(), () -> Companion.writeToFile$lambda$1(file, e2));
            }
        }

        private final BuildDifference readBuildDifference(ObjectInputStream $this$readBuildDifference) {
            long ts = $this$readBuildDifference.readLong();
            boolean isIncremental = $this$readBuildDifference.readBoolean();
            DirtyData dirtyData = this.readDirtyData($this$readBuildDifference);
            return new BuildDifference(ts, isIncremental, dirtyData);
        }

        private final void writeBuildDifference(ObjectOutputStream $this$writeBuildDifference, BuildDifference diff) {
            $this$writeBuildDifference.writeLong(diff.getTs());
            $this$writeBuildDifference.writeBoolean(diff.isIncremental());
            this.writeDirtyData($this$writeBuildDifference, diff.getDirtyData());
        }

        private final DirtyData readDirtyData(ObjectInputStream $this$readDirtyData) {
            ArrayList<LookupSymbol> lookupSymbols = this.readLookups($this$readDirtyData);
            ArrayList<FqName> dirtyClassesFqNames = this.readFqNames($this$readDirtyData);
            return new DirtyData(lookupSymbols, dirtyClassesFqNames, null, 4, null);
        }

        @NotNull
        public final ArrayList<FqName> readFqNames(@NotNull ObjectInputStream $this$readFqNames) {
            Intrinsics.checkNotNullParameter($this$readFqNames, "<this>");
            int dirtyClassesSize = $this$readFqNames.readInt();
            ArrayList<FqName> dirtyClassesFqNames = new ArrayList<FqName>(dirtyClassesSize);
            int n2 = 0;
            while (n2 < dirtyClassesSize) {
                int it = n2++;
                boolean bl = false;
                String fqNameString = $this$readFqNames.readUTF();
                Intrinsics.checkNotNull(fqNameString);
                dirtyClassesFqNames.add(new FqName(fqNameString));
            }
            return dirtyClassesFqNames;
        }

        @NotNull
        public final ArrayList<LookupSymbol> readLookups(@NotNull ObjectInputStream $this$readLookups) {
            Intrinsics.checkNotNullParameter($this$readLookups, "<this>");
            int lookupSymbolSize = $this$readLookups.readInt();
            ArrayList<LookupSymbol> lookupSymbols = new ArrayList<LookupSymbol>(lookupSymbolSize);
            int n2 = 0;
            while (n2 < lookupSymbolSize) {
                int it = n2++;
                boolean bl = false;
                String name2 = $this$readLookups.readUTF();
                String scope2 = $this$readLookups.readUTF();
                Intrinsics.checkNotNull(name2);
                Intrinsics.checkNotNull(scope2);
                lookupSymbols.add(new LookupSymbol(name2, scope2));
            }
            return lookupSymbols;
        }

        private final void writeDirtyData(ObjectOutputStream $this$writeDirtyData, DirtyData dirtyData) {
            this.writeLookups($this$writeDirtyData, dirtyData.getDirtyLookupSymbols());
            this.writeFqNames($this$writeDirtyData, dirtyData.getDirtyClassesFqNames());
        }

        public final void writeFqNames(@NotNull ObjectOutputStream $this$writeFqNames, @NotNull Collection<FqName> dirtyClassesFqNames) {
            Intrinsics.checkNotNullParameter($this$writeFqNames, "<this>");
            Intrinsics.checkNotNullParameter(dirtyClassesFqNames, "dirtyClassesFqNames");
            $this$writeFqNames.writeInt(dirtyClassesFqNames.size());
            for (FqName fqName : dirtyClassesFqNames) {
                $this$writeFqNames.writeUTF(fqName.asString());
            }
        }

        public final void writeLookups(@NotNull ObjectOutputStream $this$writeLookups, @NotNull Collection<LookupSymbol> lookupSymbols) {
            Intrinsics.checkNotNullParameter($this$writeLookups, "<this>");
            Intrinsics.checkNotNullParameter(lookupSymbols, "lookupSymbols");
            $this$writeLookups.writeInt(lookupSymbols.size());
            for (LookupSymbol lookupSymbol : lookupSymbols) {
                String name2 = lookupSymbol.component1();
                String scope2 = lookupSymbol.component2();
                $this$writeLookups.writeUTF(name2);
                $this$writeLookups.writeUTF(scope2);
            }
        }

        public final int getCURRENT_VERSION() {
            return CURRENT_VERSION;
        }

        public final void setCURRENT_VERSION(int n2) {
            CURRENT_VERSION = n2;
        }

        private static final String readDiffsFromFile$reportFail$lambda$0(File $file, String $reason) {
            return "Could not read diff from file " + $file + ": " + $reason;
        }

        private static final void readDiffsFromFile$reportFail(ICReporter $reporter, File $file, String reason) {
            block0: {
                ICReporter iCReporter = $reporter;
                if (iCReporter == null) break block0;
                ICReporterKt.info(iCReporter, () -> Companion.readDiffsFromFile$reportFail$lambda$0($file, reason));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit writeToFile$lambda$0(File $file, BuildDiffsStorage $storage) {
            Closeable closeable = new FileOutputStream($file);
            int n2 = 8192;
            closeable = new ObjectOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n2));
            Throwable throwable = null;
            try {
                ObjectOutputStream output2 = (ObjectOutputStream)closeable;
                boolean bl = false;
                output2.writeInt(Companion.getCURRENT_VERSION());
                Iterable $this$sortedBy$iv = $storage.getBuildDiffs();
                boolean $i$f$sortedBy = false;
                List<BuildDifference> diffsToWrite = CollectionsKt.takeLast(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a2, T b2) {
                        BuildDifference it = (BuildDifference)a2;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTs());
                        it = (BuildDifference)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getTs());
                    }
                }), 10);
                output2.writeInt(diffsToWrite.size());
                for (BuildDifference diff : diffsToWrite) {
                    Companion.writeBuildDifference(output2, diff);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return Unit.INSTANCE;
        }

        private static final String writeToFile$lambda$1(File $file, IOException $e) {
            return "Could not write diff to file " + $file + ": " + $e;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

