/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J$\u0010\u000f\u001a\u00020\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "extractModuleCallee", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "call", "checkReifieidTypeParameters", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsModuleCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsModuleCallChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1586#2:65\n1661#2,3:66\n777#2:69\n873#2,2:70\n1205#2,2:72\n1282#2,4:74\n1586#2:78\n1661#2,3:79\n*S KotlinDebug\n*F\n+ 1 JsModuleCallChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleCallChecker\n*L\n50#1:65\n50#1:66,3\n50#1:69\n50#1:70,2\n53#1:72,2\n53#1:74,4\n56#1:78\n56#1:79,3\n*E\n"})
public final class JsModuleCallChecker
implements CallChecker {
    @NotNull
    public static final JsModuleCallChecker INSTANCE = new JsModuleCallChecker();

    private JsModuleCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.checkReifieidTypeParameters(resolvedCall2, reportOn, context2);
        DeclarationDescriptor declarationDescriptor = this.extractModuleCallee(resolvedCall2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor callee = declarationDescriptor;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext2, context2.getTrace(), containingDescriptor, callee, reportOn);
    }

    private final DeclarationDescriptor extractModuleCallee(ResolvedCall<?> call2) {
        Object obj = call2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object callee = obj;
        if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)callee)) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiverValue = call2.getDispatchReceiver();
        if (receiverValue == null) {
            return (DeclarationDescriptor)callee;
        }
        ReceiverValue receiver = receiverValue;
        if (receiver instanceof ClassValueReceiver) {
            return ((ClassValueReceiver)receiver).getClassQualifier().getDescriptor();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifieidTypeParameters(ResolvedCall<?> call2, PsiElement reportOn, CallCheckerContext context2) {
        void $this$mapTo$iv$iv;
        Map map;
        Map map2;
        void $this$filterTo$iv$iv;
        IndexedValue it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        DeclarationDescriptor containingDescriptor = context2.getScope().getOwnerDescriptor();
        List<TypeParameterDescriptor> list = call2.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t2 : $this$mapTo$iv$iv2) {
            TypeParameterDescriptor object = (TypeParameterDescriptor)t2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginal());
        }
        Iterable $this$filter$iv = CollectionsKt.withIndex((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t3 : $this$filterTo$iv$iv) {
            it = (IndexedValue)t3;
            boolean bl22 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)it.component2();
            if (!param.isReified()) continue;
            destination$iv$iv.add(t3);
        }
        List typeParams = (List)destination$iv$iv;
        KtTypeArgumentList ktTypeArgumentList = call2.getCall().getTypeArgumentList();
        if (ktTypeArgumentList != null) {
            void $this$associateTo$iv$iv;
            KtTypeArgumentList args = ktTypeArgumentList;
            boolean bl = false;
            Iterable $this$associate$iv = typeParams;
            boolean bl2 = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable bl22 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                Object object = (IndexedValue)element$iv$iv;
                boolean bl3 = false;
                int index = ((IndexedValue)object).component1();
                TypeParameterDescriptor param = (TypeParameterDescriptor)((IndexedValue)object).component2();
                TypeParameterDescriptor typeParameterDescriptor = param.getOriginal();
                List<KtTypeProjection> list2 = args.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
                KtTypeProjection ktTypeProjection = CollectionsKt.getOrNull(list2, index);
                object = TuplesKt.to(typeParameterDescriptor, ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null);
                map3.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
            }
            map2 = destination$iv$iv2;
        } else {
            map2 = map = null;
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        Map typeArguments = map;
        Iterable $this$map$iv2 = typeParams;
        boolean $i$f$map2 = false;
        Iterable bl = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean bl3 = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            Object item$iv$iv = object.next();
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            TypeParameterDescriptor param = (TypeParameterDescriptor)indexedValue.component2();
            collection.add(param.getOriginal());
        }
        for (TypeParameterDescriptor typeParam : (List)destination$iv$iv3) {
            ClassDescriptor typeArgumentClass;
            KotlinType typeArgument;
            PsiElement argPsi;
            KtTypeReference ktTypeReference = (KtTypeReference)typeArguments.get(typeParam);
            PsiElement psiElement = argPsi = ktTypeReference != null ? (PsiElement)ktTypeReference : reportOn;
            if (call2.getTypeArguments().get(typeParam) == null || ((object = typeArgument.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)object : null) == null) continue;
            typeArgumentClass = typeArgumentClass;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, context2.getTrace(), containingDescriptor, typeArgumentClass, argPsi);
        }
    }
}

