/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import com.intellij.openapi.util.ModificationTracker;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.CacheResetOnProcessCanceled;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/storage/ExceptionTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/kotlin/storage/LockBasedStorageManager$ExceptionHandlingStrategy;", "<init>", "()V", "cancelledTracker", "Ljava/util/concurrent/atomic/AtomicLong;", "handleException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "throwable", "", "incCounter", "", "getModificationCount", "", "toString", "", "frontend"})
public class ExceptionTracker
implements ModificationTracker,
LockBasedStorageManager.ExceptionHandlingStrategy {
    @NotNull
    private final AtomicLong cancelledTracker = new AtomicLong();

    @Override
    @NotNull
    public RuntimeException handleException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (!(throwable instanceof ReenteringLazyValueComputationException || ExceptionUtilsKt.isProcessCanceledException(throwable) && !CacheResetOnProcessCanceled.INSTANCE.getEnabled())) {
            this.incCounter();
        }
        throw ExceptionUtilsKt.rethrow(throwable);
    }

    private final void incCounter() {
        this.cancelledTracker.getAndIncrement();
    }

    @Override
    public long getModificationCount() {
        return this.cancelledTracker.get();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getModificationCount();
    }
}

