/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.SerializationFirUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.FirSerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.SerializationFirCheckerUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a \u0010\u0007\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\b"}, d2={"checkCompanionOfSerializableClass", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCompanionSerializerDependency", "kotlinx-serialization-compiler-plugin.k2"})
public final class FirSerializationCompanionClassCheckerKt {
    public static final void checkCompanionOfSerializableClass(@NotNull CheckerContext $this$checkCompanionOfSerializableClass, @NotNull FirClassSymbol<?> classSymbol, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)$this$checkCompanionOfSerializableClass, (String)"<this>");
        Intrinsics.checkNotNullParameter(classSymbol, (String)"classSymbol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(classSymbol instanceof FirRegularClassSymbol)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClassSymbol)classSymbol).getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol;
        if (!SerializationFirUtilsKt.hasSerializableOrMetaAnnotation(classSymbol, $this$checkCompanionOfSerializableClass.getSession())) {
            return;
        }
        if (!SerializationFirUtilsKt.hasSerializableOrMetaAnnotation((FirClassSymbol)companionObjectSymbol, $this$checkCompanionOfSerializableClass.getSession())) {
            return;
        }
        ConeKotlinType serializableArg = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)classSymbol, $this$checkCompanionOfSerializableClass.getSession());
        ConeKotlinType companionArg = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)companionObjectSymbol, $this$checkCompanionOfSerializableClass.getSession());
        if (serializableArg != null && companionArg != null && Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)serializableArg), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)companionArg))) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)$this$checkCompanionOfSerializableClass), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.serializableOrMetaAnnotationSource((FirClassSymbol)companionObjectSymbol, $this$checkCompanionOfSerializableClass.getSession())), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_IS_SERIALIZABLE_INSIDE_SERIALIZABLE_CLASS(), classSymbol, null, (int)16, null);
    }

    public static final void checkCompanionSerializerDependency(@NotNull CheckerContext $this$checkCompanionSerializerDependency, @NotNull FirClassSymbol<?> classSymbol, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$checkCompanionSerializerDependency, (String)"<this>");
        Intrinsics.checkNotNullParameter(classSymbol, (String)"classSymbol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(classSymbol instanceof FirRegularClassSymbol)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol2 = ((FirRegularClassSymbol)classSymbol).getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol2 == null) {
            return;
        }
        FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol2;
        ConeKotlinType coneKotlinType = SerializationFirUtilsKt.getSerializerForClass((FirClassSymbol)companionObjectSymbol, $this$checkCompanionSerializerDependency.getSession());
        if (coneKotlinType == null || (firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)((SessionHolder)$this$checkCompanionSerializerDependency), (ConeKotlinType)coneKotlinType)) == null) {
            return;
        }
        FirRegularClassSymbol serializerForInCompanion = firRegularClassSymbol;
        ConeKotlinType serializableWith = SerializationFirUtilsKt.getSerializableWith((FirBasedSymbol)classSymbol, $this$checkCompanionSerializerDependency.getSession());
        CheckerContext context = $this$checkCompanionSerializerDependency;
        if (SerializationFirUtilsKt.hasSerializableOrMetaAnnotationWithoutArgs(classSymbol, $this$checkCompanionSerializerDependency.getSession())) {
            if (Intrinsics.areEqual((Object)serializerForInCompanion.getClassId(), (Object)((FirRegularClassSymbol)classSymbol).getClassId())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)$this$checkCompanionSerializerDependency), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)SerializationFirCheckerUtilsKt.serializableOrMetaAnnotationSource(classSymbol, $this$checkCompanionSerializerDependency.getSession())), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_AS_CUSTOM_SERIALIZER_DEPRECATED(), classSymbol, null, (int)16, null);
            } else {
                FirSerializationCompanionClassCheckerKt.checkCompanionSerializerDependency$reportSerializableCompanion($this$checkCompanionSerializerDependency, reporter, companionObjectSymbol, classSymbol, serializerForInCompanion);
            }
        } else if (serializableWith != null) {
            if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)serializableWith), (Object)companionObjectSymbol.getClassId()) || !Intrinsics.areEqual((Object)serializerForInCompanion.getClassId(), (Object)((FirRegularClassSymbol)classSymbol).getClassId())) {
                FirSerializationCompanionClassCheckerKt.checkCompanionSerializerDependency$reportSerializableCompanion($this$checkCompanionSerializerDependency, reporter, companionObjectSymbol, classSymbol, serializerForInCompanion);
            }
        } else {
            FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation((FirClassSymbol)companionObjectSymbol, $this$checkCompanionSerializerDependency.getSession());
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)$this$checkCompanionSerializerDependency), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_SERIALIZER_INSIDE_NON_SERIALIZABLE_CLASS(), (Object)ScopeUtilsKt.defaultType((FirClassLikeSymbol)((FirClassLikeSymbol)classSymbol)), (Object)ScopeUtilsKt.defaultType((FirClassLikeSymbol)((FirClassLikeSymbol)serializerForInCompanion)), null, (int)32, null);
        }
    }

    private static final void checkCompanionSerializerDependency$reportSerializableCompanion(CheckerContext $this_checkCompanionSerializerDependency, DiagnosticReporter $reporter, FirRegularClassSymbol companionObjectSymbol, FirClassSymbol<?> $classSymbol, FirRegularClassSymbol serializerForInCompanion) {
        FirAnnotation firAnnotation = SerializationFirUtilsKt.getSerializerAnnotation((FirClassSymbol)companionObjectSymbol, $this_checkCompanionSerializerDependency.getSession());
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)$this_checkCompanionSerializerDependency), (DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firAnnotation != null ? firAnnotation.getSource() : null)), FirSerializationErrors.INSTANCE.getCOMPANION_OBJECT_SERIALIZER_INSIDE_OTHER_SERIALIZABLE_CLASS(), (Object)ScopeUtilsKt.defaultType((FirClassLikeSymbol)((FirClassLikeSymbol)$classSymbol)), (Object)ScopeUtilsKt.defaultType((FirClassLikeSymbol)((FirClassLikeSymbol)serializerForInCompanion)), null, (int)32, null);
    }
}

