/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.system.resolver.StringResolver;

public class ResourceResolver
implements StringResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolve(String string, ClassLoader loader) {
        String parsed = string;
        Matcher matcher = Pattern.compile("(?<!\\\\)\\$R\\{(.*?)(;(.*)?)?}").matcher(parsed);
        while (matcher.find()) {
            String path = matcher.group(1);
            String charset = matcher.group(3);
            if (charset != null && (charset = charset.trim()).equals("")) {
                charset = null;
            }
            InputStream inputStream = null;
            try {
                inputStream = ResourceUtils.getResource(path, loader);
                if (inputStream != null) {
                    parsed = parsed.replace(matcher.group(), StringUtils.readStream(inputStream, charset));
                    continue;
                }
                LogManager.log("Cannot find resource " + path + " using classloader " + loader);
                parsed = null;
                break;
            }
            catch (IOException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ErrorManager.notifyDebug("Cannot close input stream after reading resource: " + matcher.group(), e);
                }
            }
        }
        return parsed;
    }
}

