/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.osgi.impl.bundle.obr.resource.ManifestEntry;
import org.osgi.impl.bundle.obr.resource.Native;
import org.osgi.impl.bundle.obr.resource.Parameter;
import org.osgi.impl.bundle.obr.resource.VersionRange;

public class Manifest
extends Hashtable {
    static final long serialVersionUID = 1L;
    List imports;
    List exports;
    ManifestEntry name;
    String activator;
    String[] classpath = new String[]{"."};
    int section;
    String location;
    Native[] _native;
    Vector duplicates = new Vector();
    static final String wordparts = "~!@#$%^&*_/?><.-+";
    ManifestEntry bsn;
    VersionRange version;
    ManifestEntry host;
    List require;

    public Manifest(InputStream in) throws IOException {
        this.parse(new InputStreamReader(in, "UTF8"));
    }

    public Manifest(Reader in) throws IOException {
        this.parse(in);
    }

    public Object put(Object header, Object value) {
        if (this.containsKey(header) && !((String)header).equalsIgnoreCase("comment")) {
            this.duplicates.add(header + ":" + value);
        }
        return super.put(header, value);
    }

    /*
     * Unable to fully structure code
     */
    void parse(Reader in) throws IOException {
        rdr = new BufferedReader(in);
        current = " ";
        buffer = rdr.readLine();
        section = 0;
        if (buffer == null || buffer.startsWith("Manifest-Version")) ** GOTO lbl14
        System.err.println("The first line of a manifest file must be the Manifest-Version attribute");
        throw new IOException("The first line of a manifest file must be the Manifest-Version attribute");
lbl-1000:
        // 1 sources

        {
            if (current.startsWith(" ")) {
                buffer = String.valueOf(buffer) + current.substring(1);
            } else {
                section += this.entry(buffer);
                buffer = current;
            }
            current = rdr.readLine();
lbl14:
            // 2 sources

            ** while (buffer != null && current != null && section == 0)
        }
lbl15:
        // 1 sources

        this.entry(buffer);
    }

    int entry(String line) throws IOException {
        if (line.length() < 2) {
            return 1;
        }
        int colon = line.indexOf(58);
        if (colon < 1) {
            this.error("Invalid header '" + line + "'");
        } else {
            String alphanum;
            String header = line.substring(0, colon).toLowerCase();
            String set = alphanum = "abcdefghijklmnopqrstuvwxyz0123456789";
            if (alphanum.indexOf(header.charAt(0)) < 0) {
                this.error("Header does not start with alphanum: " + header);
            }
            int i = 0;
            while (i < header.length()) {
                if (set.indexOf(header.charAt(i)) < 0) {
                    this.error("Header contains non alphanum, - _: " + header);
                }
                set = "_-" + alphanum;
                ++i;
            }
            String value = "";
            if (colon + 2 < line.length()) {
                value = line.substring(colon + 2);
            } else {
                this.error("No value for manifest header " + header);
            }
            if (this.section == 0) {
                if (header.equals("bundle-symbolicname")) {
                    this.bsn = (ManifestEntry)this.getEntries(value).get(0);
                }
                if (header.equals("bundle-version")) {
                    try {
                        this.version = new VersionRange(value.trim());
                    }
                    catch (Exception e) {
                        this.version = new VersionRange("0");
                        System.err.println("Invalid version attr for: " + this.bsn + " value is " + value);
                    }
                }
                if (header.equals("fragment-host")) {
                    this.host = (ManifestEntry)this.getEntries(value).get(0);
                }
                if (header.equals("require-bundle")) {
                    this.require = this.getEntries(value);
                }
                if (header.equals("import-package")) {
                    this.imports = this.getEntries(value);
                } else if (header.equals("export-package")) {
                    this.exports = this.getEntries(value);
                } else if (header.equals("bundle-activator")) {
                    this.activator = value.trim();
                } else if (header.equals("bundle-updatelocation")) {
                    this.location = value.trim();
                } else if (header.equals("bundle-classpath")) {
                    this.classpath = this.getClasspath(value);
                } else if (header.equals("bundle-nativecode")) {
                    this._native = this.getNative(value);
                }
                this.put(header, value);
            }
        }
        return 0;
    }

    void error(String msg) throws IOException {
        System.err.println("Reading manifest: " + msg);
    }

    void warning(String msg) throws IOException {
        System.err.println("Reading manifest: " + msg);
    }

    StreamTokenizer getStreamTokenizer(String line) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(line));
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(48, 57);
        st.whitespaceChars(0, 32);
        st.quoteChar(34);
        int i = 0;
        while (i < wordparts.length()) {
            st.wordChars(wordparts.charAt(i), wordparts.charAt(i));
            ++i;
        }
        return st;
    }

    String word(StreamTokenizer st) throws IOException {
        switch (st.nextToken()) {
            case -3: 
            case 34: {
                String result = st.sval;
                st.nextToken();
                return result;
            }
        }
        return null;
    }

    Parameter getParameter(StreamTokenizer st) throws IOException {
        Parameter parameter = new Parameter();
        parameter.key = this.word(st);
        if (st.ttype == 58) {
            st.nextToken();
            parameter.type = 2;
        } else {
            parameter.type = 1;
        }
        if (st.ttype == 61) {
            parameter.value = this.word(st);
            while (st.ttype == -3 || st.ttype == 34) {
                parameter.value = String.valueOf(parameter.value) + " " + st.sval;
                st.nextToken();
            }
        }
        return parameter;
    }

    public List getEntries(String line) throws IOException {
        Vector<ManifestEntry> v = new Vector<ManifestEntry>();
        HashSet<String> aliases = new HashSet<String>();
        StreamTokenizer st = this.getStreamTokenizer(line);
        do {
            Parameter parameter = this.getParameter(st);
            ManifestEntry p = new ManifestEntry(parameter.key);
            while (st.ttype == 59) {
                parameter = this.getParameter(st);
                if (parameter.value == null) {
                    aliases.add(parameter.key);
                    continue;
                }
                if (parameter.type == 1) {
                    p.addParameter(parameter);
                    continue;
                }
                if (parameter.type == 2) {
                    p.addParameter(parameter);
                    continue;
                }
                p.addParameter(parameter);
            }
            v.add(p);
            Iterator a = aliases.iterator();
            while (a.hasNext()) {
                v.add(p.getAlias((String)a.next()));
            }
        } while (st.ttype == 44);
        return v;
    }

    Native[] getNative(String line) throws IOException {
        Vector<Native> v = new Vector<Native>();
        StreamTokenizer st = this.getStreamTokenizer(line);
        do {
            Native spec = new Native();
            Vector<String> names = new Vector<String>();
            do {
                Parameter parameter = this.getParameter(st);
                if (parameter.value == null) {
                    names.add(parameter.key);
                    continue;
                }
                if (parameter.is("processor", 1)) {
                    spec.processor = parameter.value;
                    continue;
                }
                if (parameter.is("osname", 1)) {
                    spec.osname = parameter.value;
                    continue;
                }
                if (parameter.is("osversion", 1)) {
                    spec.osversion = parameter.value;
                    continue;
                }
                if (parameter.is("language", 1)) {
                    spec.language = parameter.value;
                    continue;
                }
                if (parameter.is("selection-filter", 2)) {
                    spec.filter = parameter.value;
                    continue;
                }
                this.warning("Unknown parameter for native code : " + parameter);
            } while (st.ttype == 59);
            spec.paths = new String[names.size()];
            names.copyInto(spec.paths);
            v.add(spec);
        } while (st.ttype == 44);
        Object[] result = new Native[v.size()];
        v.copyInto(result);
        return result;
    }

    String[] getClasspath(String line) throws IOException {
        StringTokenizer st = new StringTokenizer(line, " \t,");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }

    public List getImports() {
        return this.imports;
    }

    public List getExports() {
        return this.exports;
    }

    public String getActivator() {
        return this.activator;
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getClasspath() {
        return this.classpath;
    }

    public Native[] getNative() {
        return this._native;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return super.get(((String)key).toLowerCase());
        }
        return null;
    }

    public String getValue(String key) {
        return (String)super.get(key.toLowerCase());
    }

    public String getValue(String key, String deflt) {
        String s = this.getValue(key);
        if (s == null) {
            return deflt;
        }
        return s;
    }

    public String[] getRequiredExecutionEnvironments() {
        String ees = this.getValue("Bundle-RequiredExecutionEnvironment");
        if (ees != null) {
            return ees.trim().split("\\s*,\\s*");
        }
        return null;
    }

    public VersionRange getVersion() {
        if (this.version == null) {
            return new VersionRange("0");
        }
        return this.version;
    }

    public String getSymbolicName() {
        ManifestEntry bsn = this.getBsn();
        if (bsn == null) {
            String name = this.getValue("Bundle-Name");
            if (name == null) {
                name = "Untitled-" + this.hashCode();
            }
            return name;
        }
        return bsn.getName();
    }

    public String getManifestVersion() {
        return this.getValue("Bundle-ManifestVersion", "1");
    }

    public String getCopyright() {
        return this.getValue("Bundle-Copyright");
    }

    public String getDocumentation() {
        return this.getValue("Bundle-DocURL");
    }

    public String[] getCategories() {
        String cats = this.getValue("Bundle-Category");
        if (cats == null) {
            return new String[0];
        }
        return cats.split("\\s*,\\s*");
    }

    public Native[] get_native() {
        return this._native;
    }

    public void set_native(Native[] _native) {
        this._native = _native;
    }

    public ManifestEntry getBsn() {
        return this.bsn;
    }

    public void setBsn(ManifestEntry bsn) {
        this.bsn = bsn;
    }

    public Vector getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(Vector duplicates) {
        this.duplicates = duplicates;
    }

    public ManifestEntry getHost() {
        return this.host;
    }

    public void setHost(ManifestEntry host) {
        this.host = host;
    }

    public List getRequire() {
        return this.require;
    }
}

